# CSS 选择器与变量

# 选择器

CSS 选择器（Selector）是 CSS 的核心特性，

## 选择器连接

## 选择器权重

同一个元素可能被多个不同的选择器指定，因此可能会有冲突。假定 CSS 是这样的：

```css
/*A*/
p.class1[attr='value']

/*B*/
p.class1 {
}

/*C*/
p.class2 {
}

/*D*/
p {
}

/*E*/
p {
  property: value !important;
}
```

其对应的 HTML 标记为：

```html
<p style="/*F*/ property:value;" class="class1 class2" attr="value"></p>
```

那么将会按照下面的顺序应用风格：E 优先级最高，因为它使用了 `!important`，除非很有必要，尽量避免使用这个。F 其次，因为它是嵌入的风格。A 其次，因为它比其他指令更具体。C 其次，虽然它的具体程度和 B 一样，但是它在 B 之后。接下来是 B。最后是 D。

# Selectors

We can use different selectors in CSS, to group different elements and apply the same style rules to this group. These selectors also can be grouped into three categories: Element selectors, Class and ID selectors and Attribute selectors.

## Basic Selectors

### Element Selectors

The h1 and p tags are grouped and share the same rules. Instead of creating three different rules to style the paragraphs and two rules for my headers, I only make one for each.

```css
/* Individual Elements */

p {
  color: green;
  font-size: 18px;
}

h1 {
  border: 2px solid red;
  color: brown;
}

/* Grouping Elements */
span,
a,
p {
  background-color: aqua;
}
```

### Class & ID Selectors

To allow more flexibility while selecting your elements, you can specify one or more classes to an element. Each class is space-separated. We use the class attribute.

```html
<p class="danger"></p>
<h1 class="danger title"></h1>
```

In CSS, you use a period ( . ) to indicate that you are targetting a specific class name. You can chain several classes one after another.

```css
.danger {
  /* Will style the paragraph */
}

.danger.title {
  /* Will style the h1*/
}
```

ID are very similar to classes, but can only be used for one element and an element can only have one ID. ID are targetted by a pound sign ( # ) in a CSS declaration, and have more weight than classes.

```css
#special-paragraph {
  color: orange;
}

/* The class only changes the font-size */
#title {
  background-color: lightblue;
}
```

### Attribute selectors

Class and ID are attributes, but perform special roles and handled in a special way.

- Simple attribute selector, target all p element who have a key attribute:

```css
p[key] {
  color: red;
}

/* OR, all elements with a key attribute, not just p */
[key] {
  color: red;
}
```

- Exact attribute values

```css
/* If the href is https://google.com, it won't match */
a[href="google.com"] {
  color: purple;
}

/* The following are NOT equal */
[class="danger warning"] {
  color: red;
}

.danger.warning {
  color: orange;
}
```

- Partial attribute values

```css
[attribute~="val"] {
  /* Attribute contains val in a space-separated list of words */
  /* Would match "friend" in "my friend Joe" */
}

[attribute*="val"] {
  /* Select any element with an attribute whose value CONTAINS val */
}

[attribute^="val"] {
  /* Select any element with an attribute whose value BEGINS with val */
}

[attribute$="val"] {
  /* Select any element with an attribute whose value ENDS with val*/
}

[attribute|="val"] {
  /*
  Select any element with an attribute whose value starts with val followed by a dash (val-)
  OR whose value is exactly equal to val.
  */
}

[attribute="val"i] {
  /* Add a i after the value to make it case insensitive ( The value will be case insensitive, NOT the attribute name. */
}
```

## Cascading Selector

## Weight
